
; Back up Macro***************************
!macro BackupFile FILE_DIR FILE BACKUP_TO
 IfFileExists "${BACKUP_TO}\*.*" +2
  CreateDirectory "${BACKUP_TO}"
 IfFileExists "${FILE_DIR}\${FILE}" 0 +2
  Rename "${FILE_DIR}\${FILE}" "${BACKUP_TO}\${FILE}"
!macroend

!macro RestoreFile BUP_DIR FILE RESTORE_TO
 IfFileExists "${BUP_DIR}\${FILE}" 0 +2
  Rename "${BUP_DIR}\${FILE}" "${RESTORE_TO}\${FILE}"
!macroend
; END Back up Macro***************************

Section /o "HUD AND GUI TYPES" titleTOP
  SectionIn RO
SectionEnd

Section /o "=============" titleTOP2  ;Fake section for TITLE.
  SectionIn RO
SectionEnd

Section /o "    WHITE TYPES" title1  ;Fake section for TITLE.
  SectionIn RO
SectionEnd

Section /o "HUD Only" g5o1 ;Group 1 Option 1  ****** /o to clear the tick nothing = ticked        White
  SetOutPath "$INSTDIR\materials\console"
  SetOverwrite try
  File "Color GUI Menus\White GUI\cstrike\materials\console\background01.vtf"
  File "Color GUI Menus\White GUI\cstrike\materials\console\background01_widescreen.vtf"
  SetOutPath "$INSTDIR\resource"
  File "Color GUI Menus\White GUI\cstrike\resource\ClientScheme.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ChatScheme.res"
  File "Color GUI Menus\White GUI\cstrike\resource\csdbig.ttf"
  SetOutPath "$INSTDIR\resource\ui"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BaseChat.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BottomSpectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\Spectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\TextWindow.res"
  SetOutPath "$INSTDIR\scripts"
  File "Color GUI Menus\White GUI\cstrike\scripts\HudAnimations.txt"
  File "Color GUI Menus\White GUI\cstrike\scripts\HudLayout.res"
SectionEnd

Section /o "HUD Only Small Font" g5o2 ;Group 5 Option 2     White Small fonts
  SetOutPath "$INSTDIR\materials\console"
  SetOverwrite try
  File "Color GUI Menus\White GUI\cstrike\materials\console\background01.vtf"
  File "Color GUI Menus\White GUI\cstrike\materials\console\background01_widescreen.vtf"
  SetOutPath "$INSTDIR\resource"
  File "Color GUI Menus\White GUI\Small Fonts\cstrike\resource\ClientScheme.res"  ; Small fonts different
  File "Color GUI Menus\White GUI\Small Fonts\cstrike\resource\ChatScheme.res"    ; Small fonts different
  File "Color GUI Menus\White GUI\cstrike\resource\csdbig.ttf"                    ; leave this in for now it may not be used, will be named in the clientscheme but not used
  File "Color GUI Menus\White GUI\Small Fonts\cstrike\resource\SourceScheme.res"  ; Small fonts different
  SetOutPath "$INSTDIR\resource\ui"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BaseChat.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BottomSpectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\Spectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\TextWindow.res"
  SetOutPath "$INSTDIR\scripts"
  File "Color GUI Menus\White GUI\cstrike\scripts\HudAnimations.txt"
  File "Color GUI Menus\White GUI\Small Fonts\cstrike\scripts\HudLayout.res"        ; Small fonts different
SectionEnd

Section  /o "HUD+GUI" g5o3 ; Group 5 Option 3     White
SetOutPath "$INSTDIR\materials\console"
  SetOverwrite try
  File "Color GUI Menus\White GUI\cstrike\materials\console\background01.vtf"
  File "Color GUI Menus\White GUI\cstrike\materials\console\background01_widescreen.vtf"
  SetOutPath "$INSTDIR\resource"
  File "Color GUI Menus\White GUI\cstrike\resource\ClientScheme.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ChatScheme.res"
  File "Color GUI Menus\White GUI\cstrike\resource\csdbig.ttf"
  File "Color GUI Menus\White GUI\cstrike\resource\SourceScheme.res"
  SetOutPath "$INSTDIR\resource\ui"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BaseChat.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BottomSpectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\Spectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\TextWindow.res"
  SetOutPath "$INSTDIR\scripts"
  File "Color GUI Menus\White GUI\cstrike\scripts\HudAnimations.txt"
  File "Color GUI Menus\White GUI\cstrike\scripts\HudLayout.res"
SectionEnd

Section  /o "HUD+GUI Small Font" g5o4 ; Group 5 Option 4     White Small fonts
   SetOutPath "$INSTDIR\materials\console"
  SetOverwrite try
  File "Color GUI Menus\White GUI\cstrike\materials\console\background01.vtf"
  File "Color GUI Menus\White GUI\cstrike\materials\console\background01_widescreen.vtf"
  SetOutPath "$INSTDIR\resource"
  File "Color GUI Menus\White GUI\Small Fonts\cstrike\resource\ClientScheme.res"  ; Small fonts different
  File "Color GUI Menus\White GUI\Small Fonts\cstrike\resource\ChatScheme.res"    ; Small fonts different
  File "Color GUI Menus\White GUI\cstrike\resource\csdbig.ttf"                    ; leave this in for now it may not be used, will be named in the clientscheme but not used
  File "Color GUI Menus\White GUI\Small Fonts\cstrike\resource\SourceScheme.res"  ; Small fonts different
  SetOutPath "$INSTDIR\resource\ui"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BaseChat.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BottomSpectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\Spectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\TextWindow.res"
  SetOutPath "$INSTDIR\scripts"
  File "Color GUI Menus\White GUI\cstrike\scripts\HudAnimations.txt"
  File "Color GUI Menus\White GUI\Small Fonts\cstrike\scripts\HudLayout.res"       ; Small fonts different
SectionEnd


Section /o "    BLUE TYPES" title2  ;Fake section for TITLE.
  SectionIn RO
SectionEnd


Section  /o "HUD Only" g5o5 ; Group 5 Option 5     Blue
  SetOutPath "$INSTDIR\resource\console"
  SetOverwrite try
  File "Color GUI Menus\Blue GUI\cstrike\resource\ClientScheme.res"
  File "Color GUI Menus\Blue GUI\cstrike\resource\ChatScheme.res"
  File "Color GUI Menus\White GUI\cstrike\resource\csdbig.ttf"
  SetOutPath "$INSTDIR\resource\ui"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BaseChat.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BottomSpectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\Spectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\TextWindow.res"
  SetOutPath "$INSTDIR\scripts"
  File "Color GUI Menus\White GUI\cstrike\scripts\HudAnimations.txt"
  File "Color GUI Menus\White GUI\cstrike\scripts\HudLayout.res"
SectionEnd

Section  /o "HUD Only Small Font" g5o6 ; Group 5 Option 6     Blue Small fonts
  SetOutPath "$INSTDIR\resource\console"
  SetOverwrite try
  File "Color GUI Menus\Blue GUI\Small Fonts\cstrike\resource\ClientScheme.res"  ; Small fonts different
  File "Color GUI Menus\Blue GUI\Small Fonts\cstrike\resource\ChatScheme.res"    ; Small fonts different
  File "Color GUI Menus\White GUI\cstrike\resource\csdbig.ttf"                   ; leave this in for now it may not be used, will be named in the clientscheme but not used
  SetOutPath "$INSTDIR\resource\ui"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BaseChat.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BottomSpectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\Spectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\TextWindow.res"
  SetOutPath "$INSTDIR\scripts"
  File "Color GUI Menus\White GUI\cstrike\scripts\HudAnimations.txt"
  File "Color GUI Menus\White GUI\Small Fonts\cstrike\scripts\HudLayout.res"     ; Small fonts different
SectionEnd

Section  /o "HUD+GUI" g5o7 ; Group 5 Option 7     Blue
 SetOutPath "$INSTDIR\materials\console"
  SetOverwrite try
  File "Color GUI Menus\Blue GUI\cstrike\materials\console\background01.vtf"
  File "Color GUI Menus\Blue GUI\cstrike\materials\console\background01_widescreen.vtf"
  SetOutPath "$INSTDIR\resource"
  File "Color GUI Menus\Blue GUI\cstrike\resource\ClientScheme.res"
  File "Color GUI Menus\Blue GUI\cstrike\resource\ChatScheme.res"
  File "Color GUI Menus\White GUI\cstrike\resource\csdbig.ttf"
  File "Color GUI Menus\Blue GUI\cstrike\resource\SourceScheme.res"
  SetOutPath "$INSTDIR\resource\ui"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BaseChat.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BottomSpectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\Spectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\TextWindow.res"
  SetOutPath "$INSTDIR\scripts"
  File "Color GUI Menus\White GUI\cstrike\scripts\HudAnimations.txt"
  File "Color GUI Menus\White GUI\cstrike\scripts\HudLayout.res"
SectionEnd

Section  /o "HUD+GUI Small Font" g5o8 ; Group 5 Option 8     Blue Small fonts
   SetOutPath "$INSTDIR\materials\console"
  SetOverwrite try
  File "Color GUI Menus\Blue GUI\cstrike\materials\console\background01.vtf"
  File "Color GUI Menus\Blue GUI\cstrike\materials\console\background01_widescreen.vtf"
  SetOutPath "$INSTDIR\resource"
  File "Color GUI Menus\Blue GUI\Small Fonts\cstrike\resource\ClientScheme.res"   ; Small fonts different
  File "Color GUI Menus\Blue GUI\Small Fonts\cstrike\resource\ChatScheme.res"     ; Small fonts different
  File "Color GUI Menus\White GUI\cstrike\resource\csdbig.ttf"                    ; leave this in for now it may not be used, will be named in the clientscheme but not used
  File "Color GUI Menus\Blue GUI\Small Fonts\cstrike\resource\SourceScheme.res"   ; Small fonts different
  SetOutPath "$INSTDIR\resource\ui"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BaseChat.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BottomSpectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\Spectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\TextWindow.res"
  SetOutPath "$INSTDIR\scripts"
  File "Color GUI Menus\White GUI\cstrike\scripts\HudAnimations.txt"
  File "Color GUI Menus\White GUI\Small Fonts\cstrike\scripts\HudLayout.res"        ; Small fonts different
SectionEnd


Section /o "    GREEN TYPES" title3  ;Fake section for TITLE.
  SectionIn RO
SectionEnd


Section  /o "HUD Only" g5o9 ; Group 5 Option 9  Green
  SetOutPath "$INSTDIR\resource"
  SetOverwrite try
  File "Color GUI Menus\Green GUI\cstrike\resource\ClientScheme.res"
  File "Color GUI Menus\Green GUI\cstrike\resource\ChatScheme.res"
  File "Color GUI Menus\White GUI\cstrike\resource\csdbig.ttf"
  SetOutPath "$INSTDIR\resource\ui"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BaseChat.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BottomSpectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\Spectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\TextWindow.res"
  SetOutPath "$INSTDIR\scripts"
  File "Color GUI Menus\White GUI\cstrike\scripts\HudAnimations.txt"
  File "Color GUI Menus\White GUI\cstrike\scripts\HudLayout.res"
SectionEnd

Section  /o "HUD Only Small Font" g5o10 ; Group 5 Option 10  Green Small fonts
  SetOutPath "$INSTDIR\resource"
  SetOverwrite try
  File "Color GUI Menus\Green GUI\Small Fonts\cstrike\resource\ClientScheme.res"  ; Small fonts different
  File "Color GUI Menus\Green GUI\Small Fonts\cstrike\resource\ChatScheme.res"    ; Small fonts different
  File "Color GUI Menus\White GUI\cstrike\resource\csdbig.ttf"                    ; leave this in for now it may not be used, will be named in the clientscheme but not used
  SetOutPath "$INSTDIR\resource\ui"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BaseChat.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BottomSpectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\Spectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\TextWindow.res"
  SetOutPath "$INSTDIR\scripts"
  File "Color GUI Menus\White GUI\cstrike\scripts\HudAnimations.txt"
  File "Color GUI Menus\White GUI\cstrike\scripts\HudLayout.res"                  ; Small fonts different
SectionEnd

Section  /o "HUD+GUI" g5o11 ; Group 5 Option 11       Green
SetOutPath "$INSTDIR\materials\console"
  SetOverwrite try
  File "Color GUI Menus\Green GUI\cstrike\materials\console\background01.vtf"
  File "Color GUI Menus\Green GUI\cstrike\materials\console\background01_widescreen.vtf"
  SetOutPath "$INSTDIR\resource"
  File "Color GUI Menus\Green GUI\cstrike\resource\ClientScheme.res"
  File "Color GUI Menus\Green GUI\cstrike\resource\ChatScheme.res"
  File "Color GUI Menus\White GUI\cstrike\resource\csdbig.ttf"
  File "Color GUI Menus\Green GUI\cstrike\resource\SourceScheme.res"
  SetOutPath "$INSTDIR\resource\ui"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BaseChat.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BottomSpectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\Spectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\TextWindow.res"
  SetOutPath "$INSTDIR\scripts"
  File "Color GUI Menus\White GUI\cstrike\scripts\HudAnimations.txt"
  File "Color GUI Menus\White GUI\cstrike\scripts\HudLayout.res"
SectionEnd

Section  /o "HUD+GUI Small Font" g5o12 ; Group 5 Option 12  Green Small fonts
SetOutPath "$INSTDIR\materials\console"
  SetOverwrite try
  File "Color GUI Menus\Green GUI\cstrike\materials\console\background01.vtf"
  File "Color GUI Menus\Green GUI\cstrike\materials\console\background01_widescreen.vtf"
  SetOutPath "$INSTDIR\resource"
  File "Color GUI Menus\Green GUI\Small Fonts\cstrike\resource\ClientScheme.res"   ; Small fonts different
  File "Color GUI Menus\Green GUI\Small Fonts\cstrike\resource\ChatScheme.res"     ; Small fonts different
  File "Color GUI Menus\White GUI\cstrike\resource\csdbig.ttf"                     ; leave this in for now it may not be used, will be named in the clientscheme but not used
  File "Color GUI Menus\Green GUI\Small Fonts\cstrike\resource\SourceScheme.res"   ; Small fonts different
  SetOutPath "$INSTDIR\resource\ui"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BaseChat.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\BottomSpectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\Spectator.res"
  File "Color GUI Menus\White GUI\cstrike\resource\ui\TextWindow.res"
  SetOutPath "$INSTDIR\scripts"
  File "Color GUI Menus\White GUI\cstrike\scripts\HudAnimations.txt"
  File "Color GUI Menus\White GUI\cstrike\scripts\HudLayout.res"                     ; Small fonts different
SectionEnd


Section /o "=============" title4  ;Fake section for TITLE."    GUI OPTIONS"
  SectionIn RO
SectionEnd
Section /o "WHITE BACKGROUND" title5  ;Fake section for TITLE.
  SectionIn RO
SectionEnd

Section  /o "White Turkey" g6o1 ; Group 6 Option 1
  SetOutPath "$INSTDIR\materials\console"
  File "Color GUI Menus\Alternate backgrounds\White Turkey\cstrike\materials\console\background01.vtf"
  File "Color GUI Menus\Alternate backgrounds\White Turkey\cstrike\materials\console\background01_widescreen.vtf"
SectionEnd

Section  /o "White Middle east" g6o2 ; Group 6 Option 2
  SetOutPath "$INSTDIR\materials\console"
  File "Color GUI Menus\Alternate backgrounds\White Middle East\cstrike\materials\console\background01.vtf"
  File "Color GUI Menus\Alternate backgrounds\White Middle East\cstrike\materials\console\background01_widescreen.vtf"
SectionEnd

Section  /o "BLUE BACKGROUND" title6  ;Fake section for TITLE.
  SectionIn RO
SectionEnd

Section  /o "Blue Turkey" g6o3 ; Group 6 Option 3
  SetOutPath "$INSTDIR\materials\console"
  File "Color GUI Menus\Alternate backgrounds\Blue Turkey\cstrike\materials\console\background01_widescreen.vtf"
  File "Color GUI Menus\Alternate backgrounds\Blue Turkey\cstrike\materials\console\background01.vtf"
SectionEnd

Section  /o "Blue Middle east" g6o4 ; Group 6 Option 4
  SetOutPath "$INSTDIR\materials\console"
  File "Color GUI Menus\Alternate backgrounds\Blue Middle East\cstrike\materials\console\background01_widescreen.vtf"
  File "Color GUI Menus\Alternate backgrounds\Blue Middle East\cstrike\materials\console\background01.vtf"
SectionEnd

Section  /o "GREEN BACKGROUND" title7  ;Fake section for TITLE.
  SectionIn RO
SectionEnd

Section  /o "Green Turkey" g6o5 ; Group 6 Option 5
  SetOutPath "$INSTDIR\materials\console"
  File "Color GUI Menus\Alternate backgrounds\Green Turkey\cstrike\materials\console\background01_widescreen.vtf"
  File "Color GUI Menus\Alternate backgrounds\Green Turkey\cstrike\materials\console\background01.vtf"
SectionEnd

Section  /o "Green Middle east" g6o6 ; Group 6 Option 6
  SetOutPath "$INSTDIR\materials\console"
  File "Color GUI Menus\Alternate backgrounds\Green Middle East\cstrike\materials\console\background01_widescreen.vtf"
  File "Color GUI Menus\Alternate backgrounds\Green Middle East\cstrike\materials\console\background01.vtf"
SectionEnd

Section /o "=============" title8  ;Fake section for TITLE."    GUI OPTIONS"
  SectionIn RO
SectionEnd

Section /o "  TEAM MENUS" title9  ;Fake section for TITLE.
  SectionIn RO
SectionEnd


Section "Standard Team Menu" g7o1

;Put your "SEC01" files made from the wizard here!
;This one is selected first.. put the most popular option here!

SectionEnd

Section /o "Full Command Menu" g7o2
  SetOutPath "$INSTDIR\resource\ui"
  File "Teammenu options\full\cstrike\resource\ui\Teammenu.res"
SectionEnd

Section /o "XHair & Models Menu" g7o3
  SetOutPath "$INSTDIR\resource\ui"
  File "Teammenu options\XHair and Models only\cstrike\resource\UI\Teammenu.res"
SectionEnd

Section /o "XHair Menu" g7o4
  SetOutPath "$INSTDIR\resource\ui"
  File "Teammenu options\xhair only\cstrike\resource\ui\Teammenu.res"
SectionEnd

Section /o "=============" title10  ;Fake section for TITLE."    GUI OPTIONS"
  SectionIn RO
SectionEnd

Section  /o "Animation options" title11  ;Fake section for TITLE.
  SectionIn RO
SectionEnd

Section  /o "Hud Health Animation" health_anmin ;one select section
  SetOutPath "$INSTDIR\scripts"
  File "Health animation\cstrike\scripts\HudAnimations.txt"
SectionEnd

Section /o "=============" title12  ;Fake section for TITLE."    animation OPTIONS"
  SectionIn RO
SectionEnd

Section  /o "Scoreboard Options" title13  ;Fake section for TITLE.
  SectionIn RO
SectionEnd

Section  /o "Wide see thru type" g8o1 ;one select section
  SetOutPath "$INSTDIR\materials\vgui\scoreboard"
  File "Scoreboard Options\peekAboo type\cstrike\materials\vgui\scoreboard\panel-scoreboard.vmt"
  File "Scoreboard Options\peekAboo type\cstrike\materials\vgui\scoreboard\panel-scoreboard.vtf"
  SetOutPath "$INSTDIR\resource\ui"
  File "Scoreboard Options\peekAboo type\cstrike\resource\ui\ScoreBoard.res"
SectionEnd

Section  /o "Pure Plain back" g8o2 ;one select section
  SetOutPath "$INSTDIR\resource\ui"
  File "Scoreboard Options\Plain black back\cstrike\resource\ui\ScoreBoard.res"
SectionEnd

Section /o "=============" title14  ;Fake section for TITLE."    other hud and gui panels OPTIONS"
  SectionIn RO
SectionEnd

Section  /o "Other Hud Panels" title15  ;Fake section for TITLE.
  SectionIn RO
SectionEnd

Section  /o "Server Ad Panel" ad_panel ;one select section
  SetOutPath "$INSTDIR\resource\ui"
  File "server ad panel\cstrike\resource\ui\PluginHud.res"
SectionEnd

Section  /o "Spectaor Menu" spec_menu ;one select section
  SetOutPath "$INSTDIR\resource"
  File "enhanced spec menu\cstrike\resource\spectatormenu.res"
SectionEnd

;Main Menu options **************************************

Section /o "=============" title16  ;Fake section for TITLE."
  SectionIn RO
SectionEnd

Section /o "Main Menu Options" title17
  SectionIn RO
SectionEnd

Section "NO MENU" g9o1
;INSTALLS NO FILES
SectionEnd

Section /o "Pro Player Menu" g9o2
  SetOutPath "$INSTDIR\resource"
  File "Game menu options CSS\1 Pro  Player\cstrike\resource\GameMenu.res"
SectionEnd

Section /o "Pro & Pub Menu" g9o3
  SetOutPath "$INSTDIR\resource"
  File "Game menu options CSS\2 Pro & Pub Player\cstrike\resource\GameMenu.res"
SectionEnd

; This next section is a special back up
Section "-Back up files" Back_up_files ;one select section
;autoexec.cfg.... Back up and install
#Backup the owners copy...
    CreateDirectory  "$INSTDIR\cfg"    ; make sure the destination folder exists
    CopyFiles  "$INSTDIR\cfg\autoexec.cfg"  "$INSTDIR\cfg\INsanesHUD_backup\autoexec.cfg"  ; source -> destination
SectionEnd

; This next section is a special write to file
Section  /o "Menu with scripts" g9o4 ;one select section
  SetOutPath "$INSTDIR\resource"
  File "Game menu options CSS\3 MovieMaker_Pub\cstrike\resource\GameMenu.res" ; this is not associated with the below code insane placed in for cfg write
#Backup the owners copy...
#Write to the backed up file now and add INsanes scripts to the end...
FileOpen $4 "$INSTDIR\cfg\autoexec.cfg" a    ; The openmode should be one of "r" (read) "w" (write, all contents of file are destroyed) or "a" (append, meaning opened for both read and write, contents preserved).
FileSeek $4 0 END                            ; Seeks a file opened with FileOpen. Note the END, we are going to the end of the file here
FileWrite $4 "$\r$\n" ; we write a new line  ; Start writing, every new line gets the carrage code "$\r$\n" to make a new line. Also the code for ".   word "word" has to be .. word $\""word$\""   or it will not work, $\" must be before eack ".
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "//INsanes 10 Demo script, put here by the NSIS Installer automatically :) dodbits.com"
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias demotoggle $\"demo_1$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias demo_1 $\"record demo_1; echo demo_1 Recording; alias demotoggle stoppingdemo_1$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias stoppingdemo_1 $\"echo demo_1 Stopped; wait; wait; wait; stop demo; alias demotoggle demo_2$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias demo_2 $\"record demo_2; echo demo_2 Recording; alias demotoggle stoppingdemo_2$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias stoppingdemo_2 $\"echo demo_2 Stopped; wait; wait; wait; stop demo; alias demotoggle demo_3$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias demo_3 $\"record demo_3; echo demo_3 Recording; alias demotoggle stoppingdemo_3$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias stoppingdemo_3 $\"echo demo_3 Stopped; wait; wait; wait; stop demo; alias demotoggle demo_4$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias demo_4 $\"record demo_4; echo demo_4 Recording; alias demotoggle stoppingdemo_4$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias stoppingdemo_4 $\"echo demo_4 Stopped; wait; wait; wait; stop demo; alias demotoggle demo_5$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias demo_5 $\"record demo_5; echo demo_5 Recording; alias demotoggle stoppingdemo_5$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias stoppingdemo_5 $\"echo demo_5 Stopped; wait; wait; wait; stop demo; alias demotoggle demo_6$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias demo_6 $\"record demo_6; echo demo_6 Recording; alias demotoggle stoppingdemo_6$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias stoppingdemo_6 $\"echo demo_6 Stopped; wait; wait; wait; stop demo; alias demotoggle demo_7$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias demo_7 $\"record demo_7; echo demo_7 Recording; alias demotoggle stoppingdemo_7$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias stoppingdemo_7 $\"echo demo_7 Stopped; wait; wait; wait; stop demo; alias demotoggle demo_8$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias demo_8 $\"record demo_8; echo demo_8 Recording; alias demotoggle stoppingdemo_8$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias stoppingdemo_8 $\"echo demo_8 Stopped; wait; wait; wait; stop demo; alias demotoggle demo_9$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias demo_9 $\"record demo_9; echo demo_9 Recording; alias demotoggle stoppingdemo_9$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias stoppingdemo_9 $\"echo demo_9 Stopped; wait; wait; wait; stop demo; alias demotoggle demo_10$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias demo_10 $\"record demo_10; echo demo_10 Recording; alias demotoggle stoppingdemo_10$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias stoppingdemo_10 $\"echo demo_10 Stopped; wait; wait; wait; stop demo; alias demotoggle demo_1$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "//INsanes Netgraph scripts"
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "//netgraph cycle type..."
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrap $\"ngrap1$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias ngrap1 $\"net_graph 1; alias ngrap ngrap2$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias ngrap2 $\"net_graph 2; alias ngrap ngrap3$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias ngrap3 $\"net_graph 3; alias ngrap ngrap4$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias ngrap4 $\"net_graph 4; alias ngrap ngrap5$\""
FileWrite $4 "$\r$\n" ; we write a new line
FileWrite $4 "alias ngrap5 $\"net_graph 0; alias ngrap ngrap1$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "//netgraph cycle move side..."
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapside $\"ngrapleft0$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapleft0 $\"net_graphpos 1; alias ngrapside ngrapleft1$\""    ; Far left
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapleft1 $\"net_graphpos 513; alias ngrapside ngrapleft2$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapleft2 $\"net_graphpos 486; alias ngrapside ngrapleft3$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapleft3 $\"net_graphpos 432; alias ngrapside ngrapleft4$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapleft4 $\"net_graphpos 405; alias ngrapside ngrapleft5$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapleft5 $\"net_graphpos 378; alias ngrapside ngrapleft6$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapleft6 $\"net_graphpos 351; alias ngrapside ngrapleft7$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapleft7 $\"net_graphpos 324; alias ngrapside ngrapleft8$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapleft8 $\"net_graphpos 297; alias ngrapside ngrapcentre$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapcentre $\"net_graphpos 270; alias ngrapside ngrapright1$\""  ; centre is 270
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapright1 $\"net_graphpos 243; alias ngrapside ngrapright2$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapright2 $\"net_graphpos 216; alias ngrapside ngrapright3$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapright3 $\"net_graphpos 189; alias ngrapside ngrapright4$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapright4 $\"net_graphpos 162; alias ngrapside ngrapright5$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapright5 $\"net_graphpos 135; alias ngrapside ngrapright6$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapright6 $\"net_graphpos 108; alias ngrapside ngrapright7$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapright7 $\"net_graphpos 81; alias ngrapside ngrapright8$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapright8 $\"net_graphpos 54; alias ngrapside ngrapright9$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapright9 $\"net_graphpos 27; alias ngrapside ngrapright10$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapright10 $\"net_graphpos 3; alias ngrapside ngrapleft0$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "//netgraph cycle move vertical..."
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapvert $\"ngraptop0$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngraptop0 $\"net_graphheight 424; alias ngrapvert ngraptop1$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngraptop1 $\"net_graphheight 384; alias ngrapvert ngraptop2$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngraptop2 $\"net_graphheight 344; alias ngrapvert ngraptop3$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngraptop3 $\"net_graphheight 294; alias ngrapvert ngraptop4$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngraptop4 $\"net_graphheight 254; alias ngrapvert ngraptop5$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngraptop5 $\"net_graphheight 214; alias ngrapvert ngraptop6$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngraptop6 $\"net_graphheight 184; alias ngrapvert ngrapvertcent$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapvertcent $\"net_graphheight 144; alias ngrapvert ngrapbot0$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapbot0 $\"net_graphheight 134; alias ngrapvert ngrapbot1$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapbot1 $\"net_graphheight 124; alias ngrapvert ngrapbot2$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapbot2 $\"net_graphheight 114; alias ngrapvert ngrapbot3$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapbot3 $\"net_graphheight 104; alias ngrapvert ngrapbot4$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapbot4 $\"net_graphheight 94; alias ngrapvert ngrapbot5$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapbot5 $\"net_graphheight 84; alias ngrapvert ngrapbot6$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapbot6 $\"net_graphheight 74; alias ngrapvert ngrapbot7$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapbot7 $\"net_graphheight 64; alias ngrapvert ngrapbot8$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapbot8 $\"net_graphheight 54; alias ngrapvert ngrapbot9$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapbot9 $\"net_graphheight 44; alias ngrapvert ngrapbot10$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "alias ngrapbot10 $\"net_graphheight 34; alias ngrapvert ngraptop0$\""
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "$\r$\n" ; write an extra line
FileWrite $4 "//end INsanes Netgraph Script"
FileClose $4 ; close the file now the demo script is in
SectionEnd

Section /o "=============" title18  ;Fake section for TITLE."
  SectionIn RO
SectionEnd

Section  /o "Blurry Avatars" blur_avas ;one select section
  SetOutPath "$INSTDIR\materials\VGUI"
  File "Color GUI Menus\CSS Images Fix\cstrike\materials\VGUI\avatar_default_64.vtf"
  File "Color GUI Menus\CSS Images Fix\cstrike\materials\VGUI\avatar_default-t_64.vtf"
SectionEnd

# defines for newer versions

!include Sections.nsh

;dodbits.com by INsane Steam folder finder for dod source....
;It will detect the Vista install path and if not found move to XP... if no luck it will do a manual install

;Looking for Vista or XP install path... querying the registry now...
;InstallDirRegKey HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Steam App 300" "InstallLocation"  ;240 css and 300 dods
InstallDirRegKey HKCU "Software\Valve\Steam" "ModInstallPath"


Function  .onInit
;If Windows Vista is there, read this and go to ok next or not finding Vista go to WinXP next...
ReadRegStr $R0 HKLM "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Steam App 240" "InstallLocation"  ;240 css and 300 dods
;If we did not find it, lets look for XP now or go to ok if we did find it...
IfErrors winXPsearch ok
winXPsearch:
;Vista seems not to be there. Will now read a XP registry key and go to ok or noXP next...
ReadRegStr $R0 HKCU "Software\Valve\Steam" "ModInstallPath"   ;"Software\Valve\Steam" "ModInstallPath"
;If we did not find it, lets forget this and show a message, or go to ok if we did find it...
IfErrors noXP ok
noXP:
messageBox MB_OK "Can't find your dod folder, press OK and continue to install!" IDOK done
; If we did not find any reg keys the message has displayed and the user pressed ok, he skipped this next bit and went to done
; if we did find the key we can now contine...
ok:
Loop:
StrLen $R1 $R0
StrCpy $R2 $R0 $R1 -1
StrCpy $R0 $R0 -1
StrCmp "\" $R2 fin loop
fin:
StrCpy $INSTDIR $R0
StrCpy $INSTDIR "$INSTDIR\counter-strike source\cstrike" ;Change this for other mods like... \counter-strike source\cstrike

done:
FunctionEnd
;END of the Steam folder finder Function


Function .onSelChange

;Inserted here are radio button options that work differently from the above 3 add as man as you like here in groups

 !insertmacro StartRadioButtons $5   ; These are the main HUD choices
    !insertmacro RadioButton ${g5o1}  ; White HUD
    !insertmacro RadioButton ${g5o2}  ; White HUD Small Fonts
    !insertmacro RadioButton ${g5o3}  ; White HUD and GUI
    !insertmacro RadioButton ${g5o4}  ; White HUD and GUI Small Fonts
    !insertmacro RadioButton ${g5o5}  ; Blue HUD
    !insertmacro RadioButton ${g5o6}  ; Blue HUD Small Fonts
    !insertmacro RadioButton ${g5o7}  ; Blue HUD and GUI
    !insertmacro RadioButton ${g5o8}  ; Blue HUD and GUI Small Fonts
    !insertmacro RadioButton ${g5o9}  ; Green HUD
    !insertmacro RadioButton ${g5o10} ; Green HUD Small Fonts
    !insertmacro RadioButton ${g5o11} ; Green HUD and GUI
    !insertmacro RadioButton ${g5o12} ; Green HUD and GUI Small Fonts
  !insertmacro EndRadioButtons
  
  !insertmacro StartRadioButtons $6   ; These are the main HUD choices
    !insertmacro RadioButton ${g6o1}  ; White Turkey
    !insertmacro RadioButton ${g6o2}  ; White Middle east
    !insertmacro RadioButton ${g6o3}  ; Blue Turkey
    !insertmacro RadioButton ${g6o4}  ; Blue Middle east
    !insertmacro RadioButton ${g6o5}  ; Green Turkey
    !insertmacro RadioButton ${g6o6}  ; Green Middle east
  !insertmacro EndRadioButtons
  
  !insertmacro StartRadioButtons $7   ; These are the team menu choices
    !insertmacro RadioButton ${g7o1}  ; Standard Team Menu
    !insertmacro RadioButton ${g7o2}  ; A Team Menu that has many buttons with handy commands
    !insertmacro RadioButton ${g7o3}  ; A Team Menu that has buttons to adjust Crosshairs and cl_minmodels, that is making one model type for the whole team
    !insertmacro RadioButton ${g7o4}  ; A Team Menu that has buttons to adjust Crosshairs
  !insertmacro EndRadioButtons
  
  !insertmacro StartRadioButtons $8   ; These are the scoreboard choices
    !insertmacro RadioButton ${g8o1}  ; Peak a boo wide
    !insertmacro RadioButton ${g8o2}  ; Plain Black back
  !insertmacro EndRadioButtons
  
  !insertmacro StartRadioButtons $9   ;Main Menu Options
    !insertmacro RadioButton ${g9o1}  ; No Menu default selected
    !insertmacro RadioButton ${g9o2}  ; Pro Player
    !insertmacro RadioButton ${g9o3}  ; Pro Player No cfg scripts and a few pub buttons
    !insertmacro RadioButton ${g9o4}  ; With Netgraph and cfg scripts
  !insertmacro EndRadioButtons

FunctionEnd
;END of options control Functions.


; Whats left of the Wizards Normal script is now left below... compile and run and test it!

; Script generated by the HM NIS Edit Script Wizard.

; MUI section
; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "INsanes CSS HUD"
!define PRODUCT_VERSION "7"
!define PRODUCT_PUBLISHER "INsane"
!define PRODUCT_WEB_SITE "http://www.dodbits.com"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

; MUI 1.67 compatible ------ define the installer look and feel here

;*****Start "MUI Settings"

!include "UMUI.nsh"

;*****  This is the check box graphic type, this define and the address after it allows the use of custom checkboxes.
!define MUI_COMPONENTSPAGE_CHECKBITMAP "${NSISDIR}\Contrib\Graphics\Checks\blank-arrow-tick.bmp"

;***** Custom message about your options.
ComponentText "CLICK ONE HUD, GUI / HUD OPTION. WHITE  BLUE  GREEN TYPES $\r $\r AFTER YOU HAVE YOUR SELECTION, CONTINUE TO THE OTHER OPTIONS. ENJOY INsane." ;custom message about your options.

;*****The Icons for the setup file and the un-install icons...

!define MUI_ICON "${NSISDIR}\Contrib\Graphics\UltraModernUI\Icon.ico" ; The install icon, ico file address.

!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\UltraModernUI\UnIcon.ico" ; The Un-install icon, ico file address.

;***** The main body colors, font colors of the titles and main body fonts...

!define UMUI_TEXT_COLOR F5F5F5 ;  This is the Text Color of the font on the installer main body.

!define MUI_BGCOLOR 333333 ; This is the background color of the installer main body.

!define UMUI_TEXT_LIGHTCOLOR F5F5F5 ; Font color of Titles like the "Description" in the components screen and "Destination Folder" on the install screen.

;***** The Two installer images, extract the standard ones from... "C:\Program Files\NSIS\Contrib\UltraModernUI\Skins\blue" (or grey, green / other folders) work on them, save them and adjust the new name and address to suit.

!define UMUI_LEFTIMAGE_BMP "Installer Graphics\Wizard\164x314SteamModInstallerCSS.bmp" ;The file address of the 171 wide X 384 High .BMP graphic file for the left side image.

!define UMUI_HEADERBGIMAGE_BMP "Installer Graphics\Wizard\HeaderSteamModInstallerCSS.bmp" ; The file address of the 690 wide X 59 High .BMP graphic file for the top Header image.

;***** The Bottom Bar adjustments, in the same place as the above images, plus some font colors and "Branding text"...

;***** Custom brand on the botttom bar This replaces the standard text
BrandingText "dodbits Steam Mod Installer"

;!define UMUI_BOTTOMIMAGE_BMP "Installer Graphics\MUI_dodbits_gray\BtmImg.bmp" ; The file address of the 690 wide X 30 High .BMP graphic file for the top Header image. The bottom bar graphics file address.

!define UMUI_BRANDINGTEXTFRONTCOLOR F5F5F5 ;The topside font color for the "Brand Name" on the bottom bar.

!define UMUI_BRANDINGTEXTBACKCOLOR 000000 ;The background (shadow) font color for the "Brand Name" on the bottom bar.

!define MUI_LICENSEPAGE_BGCOLOR C0C0C0

; End  "MUI Settings"




; Welcome page
!insertmacro MUI_PAGE_WELCOME
; Components page
!insertmacro MUI_PAGE_COMPONENTS
; License page
!insertmacro MUI_PAGE_LICENSE  README.txt
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "Setup INsanes CSS HUD V7.exe"
InstallDir "$INSTDIR"
ShowInstDetails show
ShowUnInstDetails show



Section -Post
  WriteUninstaller "$INSTDIR\uninst INsanes CSS HUD V7.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst INsanes CSS HUD V7.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd


; Section descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${titleTOP} ""
  !insertmacro MUI_DESCRIPTION_TEXT ${titleTOP2} ""
  !insertmacro MUI_DESCRIPTION_TEXT ${title1} "WHITE GUI and HUD Options"
  !insertmacro MUI_DESCRIPTION_TEXT ${g5o1} "WHITE HUD. $\r$\rNORMAL Fonts $\r$\rReworked Spectator, Buy and MOTD screens. $\r$\rSelect this and scroll down for other custom items"
  !insertmacro MUI_DESCRIPTION_TEXT ${g5o2} "WHITE HUD Small Fonts $\r$\rSMALL Fonts $\r$\rReworked Spectator, Buy and MOTD screens $\r$\rSelect this and scroll down for other custom items"
  !insertmacro MUI_DESCRIPTION_TEXT ${g5o3} "WHITE GUI & HUD. $\r$\rNORMAL Fonts $\r$\rReworked GUI Panels and background. HUD Spectator, Buy and MOTD screens. $\r$\rSelect this and scroll down for other custom items"
  !insertmacro MUI_DESCRIPTION_TEXT ${g5o4} "WHITE GUI & HUD Small Fonts $\r$\rSMALL Fonts $\r$\rReworked GUI Panels and background. HUD Spectator, Buy and MOTD screens $\r$\rSelect this and scroll down for other custom items."
  !insertmacro MUI_DESCRIPTION_TEXT ${title2} "Blue GUI and HUD Options."
  !insertmacro MUI_DESCRIPTION_TEXT ${g5o5} "BLUE HUD. $\r$\rNORMAL Fonts. $\r$\rReworked Spectator, Buy and MOTD screens. $\r$\rSelect this and scroll down for other custom items."
  !insertmacro MUI_DESCRIPTION_TEXT ${g5o6} "BLUE HUD Small Fonts. $\r$\rSMALL Fonts. $\r$\rReworked Spectator, Buy and MOTD screens.  $\r$\rSelect this and scroll down for other custom items."
  !insertmacro MUI_DESCRIPTION_TEXT ${g5o7} "BLUE GUI & HUD. $\r$\rNORMAL Fonts. $\r$\rReworked GUI Panels and background. HUD Spectator, Buy and MOTD screens. $\r$\rSelect this and scroll down for other custom items."
  !insertmacro MUI_DESCRIPTION_TEXT ${g5o8} "BLUE GUI & HUD Small Fonts. $\r$\rSMALL Fonts. $\r$\rReworked GUI Panels and background. HUD Spectator, Buy and MOTD screens.  $\r$\rSelect this and scroll down for other custom items."
  !insertmacro MUI_DESCRIPTION_TEXT ${title3} "GREEN GUI and HUD Options."
  !insertmacro MUI_DESCRIPTION_TEXT ${g5o9} "GREEN HUD. $\r$\rNORMAL Fonts. $\r$\rReworked Spectator, Buy and MOTD screens. $\r$\rSelect this and scroll down for other custom items."
  !insertmacro MUI_DESCRIPTION_TEXT ${g5o10} "GREEN HUD Small Fonts. $\r$\rSMALL Fonts. $\r$\rReworked Spectator, Buy and MOTD screens.  $\r$\rSelect this and scroll down for other custom items."
  !insertmacro MUI_DESCRIPTION_TEXT ${g5o11} "GREEN GUI & HUD. $\r$\rNORMAL Fonts. $\r$\rReworked GUI Panels and background. HUD Spectator, Buy and MOTD screens. $\r$\rSelect this and scroll down for other custom items."
  !insertmacro MUI_DESCRIPTION_TEXT ${g5o12} "GREEN GUI & HUD Small Fonts. $\r$\rSMALL Fonts. $\r$\rReworked GUI Panels and background. HUD Spectator, Buy and MOTD screens.  $\r$\rSelect this and scroll down for other custom items."
  !insertmacro MUI_DESCRIPTION_TEXT ${title4} "More Options for GUIs and HUDs below, some only allow one option so you get exactly what you want."
  !insertmacro MUI_DESCRIPTION_TEXT ${title5} "WHITE ALTERNATE GUI BACKGROUNDS."
  !insertmacro MUI_DESCRIPTION_TEXT ${g6o1} "Gray Black IMAGE, CT in front of a Turkey Church Background."
  !insertmacro MUI_DESCRIPTION_TEXT ${g6o2} "Gray Black IMAGE, TER & CT in front of a Middle Eastern building."
  !insertmacro MUI_DESCRIPTION_TEXT ${title6} "BLUE ALTERNATE GUI BACKGROUNDS."
  !insertmacro MUI_DESCRIPTION_TEXT ${g6o3} "BLUE IMAGE, CT in front of a Turkey Church Background."
  !insertmacro MUI_DESCRIPTION_TEXT ${g6o4} "BLUE IMAGE, TER & CT in front of a Middle Eastern building."
  !insertmacro MUI_DESCRIPTION_TEXT ${title7} "GREEN ALTERNATE GUI BACKGROUNDS."
  !insertmacro MUI_DESCRIPTION_TEXT ${g6o5} "GREEN IMAGE, CT in front of a Turkey Church Background."
  !insertmacro MUI_DESCRIPTION_TEXT ${g6o6} "GREEN IMAGE, TER & CT in front of a Middle Eastern building."
  !insertmacro MUI_DESCRIPTION_TEXT ${title8} "MORE OPTIONS. $\r$\rSome are Multipule Choice and will only allow one selection, others are a single on or off option."
  !insertmacro MUI_DESCRIPTION_TEXT ${title9} "ALTERNATE TEAM MENUS."
  !insertmacro MUI_DESCRIPTION_TEXT ${g7o1} "Standard Team Menu... leave this ticked if you DO NOT want a custom one."
  !insertmacro MUI_DESCRIPTION_TEXT ${g7o2} "A Team Menu that has many buttons with handy commands. $\r$\rCrosshair, Netcode, Chat and many more $\r$\rWILL WORK FOR ALL LANGUAGES."
  !insertmacro MUI_DESCRIPTION_TEXT ${g7o3} "A Team Menu that has buttons to adjust Crosshairs and cl_minmodels, that is making one model type for the whole team  $\r$\rWILL WORK FOR ALL LANGUAGES."
  !insertmacro MUI_DESCRIPTION_TEXT ${g7o4} "A Team Menu that has buttons to adjust Crosshairs $\r$\rWILL WORK FOR ALL LANGUAGES."
  !insertmacro MUI_DESCRIPTION_TEXT ${title10} "Below here are some single options"
  !insertmacro MUI_DESCRIPTION_TEXT ${title11} "Animation options $\r$\rThe HUD_Animations.txt files are all the same in this HUD, this allows me to offer animations easy. However I only have one so far."
  !insertmacro MUI_DESCRIPTION_TEXT ${health_anmin} "Hud Health Animation. $\r$\rThe Health Icon and Text will turn read and jump to the center, lower part of the hud when below 20 or so.$\r$\r This makes it easy to notice."
  !insertmacro MUI_DESCRIPTION_TEXT ${title12} ""
  !insertmacro MUI_DESCRIPTION_TEXT ${title13} "Scoreboard Options."
  !insertmacro MUI_DESCRIPTION_TEXT ${g8o1} "A See Through Wide Scoreboard $\r$\rWill NOT show the special background on some sv_pure 1 server or any sv_pure 2 server. $\r$\rIf this happens don't worry, the default background WILL show and the hud will not mess up."
  !insertmacro MUI_DESCRIPTION_TEXT ${g8o2} "A See Through plain black background $\r$\rWill work without fault on a sv_pure 0, 1 or 2 server"
  !insertmacro MUI_DESCRIPTION_TEXT ${title14} ""
  !insertmacro MUI_DESCRIPTION_TEXT ${title15} "Options for other parts of the HUD and GUI dealing with plugins like Mani and SourceMod"
  !insertmacro MUI_DESCRIPTION_TEXT ${ad_panel} "Alters the position of ADs on servers that display on the top left corner. $\r$\rDoes not work on all resolutions but it helps to push the AD away from the radar."
  !insertmacro MUI_DESCRIPTION_TEXT ${spec_menu} "A Spectator Menu that has added commands. $\r$\rNetcode, Netgraph. $\r$\rWhy? While you are waiting in spec' have a play with this and set your net_graph, check your settings."
  !insertmacro MUI_DESCRIPTION_TEXT ${title16} ""
  !insertmacro MUI_DESCRIPTION_TEXT ${title17} "Main Menu Options"
  !insertmacro MUI_DESCRIPTION_TEXT ${g9o1} "No Menu option. $\r$\rThis installs NO FILES $\r$\rThis is the default selection, $\r$\rYou keep the CSS default Menu"
  !insertmacro MUI_DESCRIPTION_TEXT ${g9o2} "Main Menu with commands $\r$\rMade with the Pro Player in Mind. $\r$\rTwo file Demo record for each round, Status and ScreenShot buttons, $\r$\rDemo player, console, cvar report tool. $\r$\rThere are NO ADDITIOAL CFG FILES NEEDED FOR THIS TYPE $\r$\rRecommended for Competitive players"
  !insertmacro MUI_DESCRIPTION_TEXT ${g9o3} "Main Menu with MORE commands $\r$\rFor the Pro Player who wants a little more for Pub servers as well $\r$\rTwo file Demo record for each round. Status and ScreenShot buttons $\r$\rDemo player, Clear screenshot, console, cvar report tool, noob admin music mute $\r$\rThere are NO ADDITIOAL CFG FILES NEEDED FOR THIS TYPE $\r$\rRecommended for Public and Competitive players"
  !insertmacro MUI_DESCRIPTION_TEXT ${g9o4} "Main Menu with commands and a special script $\r$\rMade for a Movie Maker and casual player who hates the console $\r$\rAll of the above commands and more to make your life simple $\r$\r10 Demo recorder and netgraph control added $\r$\rThis writes the scripts automatically to the end of your autoexec.cfg file $\r$\rWorried? Install maually later if you like!"
  !insertmacro MUI_DESCRIPTION_TEXT ${title18} ""
  !insertmacro MUI_DESCRIPTION_TEXT ${blur_avas} "Fixes a few VTF files not made correctly from VALVe. $\r$\rDefault avatars Main Menus blur when FPS configs drop quality settings"
!insertmacro MUI_FUNCTION_DESCRIPTION_END


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd
;Get rid of files now...
Section Uninstall
  Delete "$INSTDIR\uninst INsanes CSS HUD V7.exe"
  Delete "$INSTDIR\materials\vgui\scoreboard\panel-scoreboard.vtf"
  Delete "$INSTDIR\materials\vgui\scoreboard\panel-scoreboard.vmt"
  Delete "$INSTDIR\materials\console\background01.vtf"
  Delete "$INSTDIR\materials\console\background01_widescreen.vtf"
  Delete "$INSTDIR\materials\VGUI\avatar_default_64.vtf"
  Delete "$INSTDIR\materials\VGUI\avatar_default-t_64.vtf"
  Delete "$INSTDIR\resource\ui\PluginHud.res"
  Delete "$INSTDIR\resource\ui\ScoreBoard.res"
  Delete "$INSTDIR\resource\GameMenu.res"
  Delete "$INSTDIR\resource\spectatormenu.res"
  Delete "$INSTDIR\resource\SourceScheme.res"
  Delete "$INSTDIR\scripts\HudLayout.res"
  Delete "$INSTDIR\resource\ui\ChatFilters.res"
  Delete "$INSTDIR\resource\ui\BaseChat.res"
  Delete "$INSTDIR\resource\ClientScheme.res"
  Delete "$INSTDIR\resource\ChatScheme.res"
  Delete "$INSTDIR\resource\csdbig.ttf"
  Delete "$INSTDIR\resource\SourceScheme.res"
  Delete "$INSTDIR\resource\ui\Teammenu.res"
  Delete "$INSTDIR\scripts\HudLayout.res"
  Delete "$INSTDIR\scripts\HudAnimations.txt"
  Delete "$INSTDIR\resource\ui\TextWindow.res"
  Delete "$INSTDIR\resource\ui\Spectator.res"
  Delete "$INSTDIR\resource\ui\BottomSpectator.res"
  Delete "$INSTDIR\resource\ClientScheme.res"

;RESTORE AND DELETE BACK UP FILES AND FOLDERS.....


;Now Delete the owners file with added text by the installer...
  Delete "$INSTDIR\cfg\autoexec.cfg"
  
#Restore copy of owners autoexec.cfg
!insertmacro RestoreFile "$INSTDIR\cfg\INsanesHUD_backup" "autoexec.cfg" "$INSTDIR\cfg"

;Now Delete the owners Backup folder...
  RMDir "$INSTDIR\cfg\INsanesHUD_backup"
  
;END RESTORE AND DELETE BACK UP FILES AND FOLDERS.....
  
;Get rid of other folders to complete entire clean, they will not delete if files are let in...
  RMDir "$INSTDIR\materials"
  RMDir "$INSTDIR\materials\console"
  RMDir "$INSTDIR\materials\vgui"
  RMDir "$INSTDIR\materials\vgui\scoreboard"
  RMDir "$INSTDIR\scripts"
  RMDir "$INSTDIR\resource\ui"
  RMDir "$INSTDIR\resource"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  SetAutoClose true
SectionEnd